#include "SetStepsPerIterationCommand.h"
#include "SimulationEngineController.h"
#include "../DataTypes/DataInteger.h"
#include "../DataTypes/DataString.h"
namespace SimulationEngine
{

SetStepsPerIterationCommand::SetStepsPerIterationCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandStepsPerIterationKey())
{
}

SetStepsPerIterationCommand::~SetStepsPerIterationCommand()
{
}

list<DataParameter*> SetStepsPerIterationCommand::execute(list <DataParameter *> pars)
{
	DataInteger *dataint = (DataInteger *)(pars.front());
	SimulationEngineController::GetInstance()->SetStepsPerIteration(dataint->GetValue());
	list <DataParameter *> ret;
	ret.push_back(new DataString("Steps per Iteration parameter has been successfully setted"));
	return ret;
}

}
